#!/bin/bash

SCRIPT_DIR=$(dirname "$(realpath "${BASH_SOURCE[0]}")")

usage () {
  echo "Usage: $(basename "$0") [-v|--verbose] [--dry-run] [--udevdir /etc/] [PREFIX]"
}

while [[ $# -gt 0 ]]; do
  case "$1" in
    --help)
      usage
      exit 0
      ;;
    --verbose|-v)
      set -x
      shift
      ;;
    --dry-run)
      DRY_RUN="echo"
      shift
      ;;
    --udevdir)
      UDEVDIR=$2
      shift 2
      ;;
    --*)
      usage
      exit 1
      ;;
    *)
      break;
      ;;
  esac
done

if [ $# -gt 1 ]; then
  usage
  exit 1
fi

set -e

PREFIX=${1:-/usr/local}
if [ -z "$UDEVDIR" ]; then
  case ${PREFIX%/} in
    /usr)
      UDEVDIR="/usr/lib"
      ;;
    *)
      UDEVDIR="/etc"
      ;;
  esac
fi

echo "Using sudo to remove files from $PREFIX. You may be asked for your password now"
dryrun_sudo="$DRY_RUN sudo"

$dryrun_sudo rm -f "$PREFIX/lib/firmware/hid/bpf/10-FR-TEC__Raptor-Mach-2.bpf.o"
$dryrun_sudo rm -f "$PREFIX/lib/firmware/hid/bpf/10-HP__Elite-Presenter.bpf.o"
$dryrun_sudo rm -f "$PREFIX/lib/firmware/hid/bpf/10-Huion__Kamvas-Pro-19.bpf.o"
$dryrun_sudo rm -f "$PREFIX/lib/firmware/hid/bpf/10-IOGEAR__Kaliber-MMOmentum.bpf.o"
$dryrun_sudo rm -f "$PREFIX/lib/firmware/hid/bpf/10-Microsoft__XBox-Elite-2.bpf.o"
$dryrun_sudo rm -f "$PREFIX/lib/firmware/hid/bpf/10-Wacom__ArtPen.bpf.o"
$dryrun_sudo rm -f "$PREFIX/lib/firmware/hid/bpf/10-XPPen__Artist24.bpf.o"
$dryrun_sudo rm -f "$PREFIX/lib/firmware/hid/bpf/10-XPPen__ArtistPro16Gen2.bpf.o"
$dryrun_sudo rm -f "$PREFIX"/bin/udev-hid-bpf
$dryrun_sudo rm -f "$UDEVDIR"/udev/rules.d/81-hid-bpf.rules
$dryrun_sudo rm -f "$UDEVDIR"/udev/hwdb.d/81-hid-bpf-*.hwdb
$DRY_RUN sudo udevadm control --reload
$DRY_RUN sudo systemd-hwdb update
